/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.block.LOTRBlockFlower;
import lotr.common.fac.LOTRFaction;
import lotr.common.world.biome.LOTRBiomeGenDolGuldur;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class LOTRBlockMorgulRose
extends LOTRBlockFlower {
    public LOTRBlockMorgulRose() {
        float f = 0.125f;
        this.setFlowerBounds(f, 0.0f, f, 1.0f - f, 0.8f, 1.0f - f);
        this.func_149675_a(true);
    }

    public boolean func_149718_j(World world, int i, int j, int k) {
        return super.func_149718_j(world, i, j, k) || LOTRBiomeGenDolGuldur.isSurfaceGuldurBlock(world, i, j - 1, k);
    }

    public void func_149674_a(World world, int i, int j, int k, Random random) {
        super.func_149674_a(world, i, j, k, random);
        if (!world.field_72995_K && world.func_72807_a(i, k) instanceof LOTRBiomeGenDolGuldur) {
            double range = 5.0;
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1)).func_72314_b(range, range, range);
            List entities = world.func_72872_a(EntityLivingBase.class, aabb);
            for (Object obj : entities) {
                EntityLivingBase entity = (EntityLivingBase)obj;
                if (!this.isEntityVulnerable(entity)) continue;
                int dur = 200;
                entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, dur));
            }
        }
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        EntityLivingBase living;
        super.func_149670_a(world, i, j, k, entity);
        if (!world.field_72995_K && entity instanceof EntityLivingBase && this.isEntityVulnerable(living = (EntityLivingBase)entity)) {
            int dur = 100;
            living.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, dur));
            living.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, dur * 2));
        }
    }

    private boolean isEntityVulnerable(EntityLivingBase entity) {
        if (LOTRMod.getNPCFaction((Entity)entity) == LOTRFaction.DOL_GULDUR) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            if (entityplayer.field_71075_bZ.field_75098_d) {
                return false;
            }
            float alignment = LOTRLevelData.getData(entityplayer).getAlignment(LOTRFaction.DOL_GULDUR);
            float max = 250.0f;
            if (alignment >= 250.0f) {
                return false;
            }
            if (alignment > 0.0f) {
                float f = alignment / max;
                f = 1.0f - f;
                return entity.func_70681_au().nextFloat() < f;
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int i, int j, int k, Random random) {
        if (world.func_147439_a(i, j, k) == this && world.func_72805_g(i, j, k) == 0 && random.nextInt(10) == 0) {
            world.func_72869_a("smoke", (double)((float)i + random.nextFloat()), (double)((float)j + 0.65f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }
}

